#include "General.h"
#include "RemoveWeakerDoubleGun.h"
#include "PhysicalGameObj.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

#define ROYAL_BLUE "65,105,225"

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	Console_Input(buffer);
}

// Uses CMSGP if scripts verion supports it, otherwise uses PPAGE
void Page(int ID, const char* rgb_colour, const char *Format, ...)
{
	if ( (ID < 1) || (ID > 128) ) return;
	if (!Get_GameObj(ID)) return;

	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	float Version = Get_Client_Version(ID);

	if (Version < 2.9)
	{
		Console("PPAGE %d %s", ID, buffer);
	}
	else
	{
		Console("CMSGP %d %s %s", ID, rgb_colour, buffer);
	}
}

RemoveWeakerDoubleGun::RemoveWeakerDoubleGun()
{
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}

RemoveWeakerDoubleGun::~RemoveWeakerDoubleGun()
{
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}

void RemoveWeakerDoubleGun::OnObjectCreate(void *data,GameObject *obj)
{
	if ( obj->As_PhysicalGameObj() && obj->As_PhysicalGameObj()->As_PowerUpGameObj() )
	{
		Attach_Script_Once(obj, "RemoveWeakerDoubleGun_Script", "");
	}
}

void RemoveWeakerDoubleGun_Script::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if ( (message == 1000000025) && Commands->Is_A_Star(sender) )
	{
		int Team = Get_Player_Type(sender);
		int PlayerID = Get_Player_ID(sender);

		if ((Has_Weapon(sender, "Weapon_RepairGun_Player")) && (Has_Weapon(sender, "CnC_Weapon_RepairGun_Player_Special")))
		{
			Page(PlayerID, ROYAL_BLUE, "Your weaker, double Repair Gun has been removed from your weapons bag.");
			Remove_Weapon(sender, "Weapon_RepairGun_Player");
		}
		else if ((Has_Weapon(sender, "Weapon_AutoRifle_Player")) && (Has_Weapon(sender, "Weapon_AutoRifle_Player_Nod")))
		{
			Page(PlayerID, ROYAL_BLUE, "Your weaker, double Auto Rifle has been removed from your weapons bag.");
			Remove_Weapon(sender, "Weapon_AutoRifle_Player_Nod");
		}
		else if ((Has_Weapon(sender, "Weapon_Chaingun_Player")) && (Has_Weapon(sender, "Weapon_Chaingun_Player_Nod")))
		{
			if ( Team == 0 ) // Nod
			{
				Remove_Weapon(sender, "Weapon_Chaingun_Player");
			}
			else
			{
				Remove_Weapon(sender, "Weapon_Chaingun_Player_Nod");
			}
			Page(PlayerID, ROYAL_BLUE, "Your double Chaingun has been removed from your weapons bag.");
		}
		else if ((Has_Weapon(sender, "CnC_Weapon_RamjetRifle_Player")) && (Has_Weapon(sender, "Weapon_RamjetRifle_Player")))
		{
			Page(PlayerID, ROYAL_BLUE, "Your weaker, double Ramjet Rifle has been removed from your weapons bag.");
			Remove_Weapon(sender, "Weapon_RamjetRifle_Player");
		}
		else if ((Has_Weapon(sender, "CnC_Weapon_RocketLauncher_Player")) && (Has_Weapon(sender, "Weapon_RocketLauncher_Player")))
		{
			Page(PlayerID, ROYAL_BLUE, "Your weaker, double Rocket Launcher has been removed from your weapons bag.");
			Remove_Weapon(sender, "Weapon_RocketLauncher_Player");
		}
		else if ((Has_Weapon(sender, "CnC_Weapon_SniperRifle_Player")) || (Has_Weapon(sender, "CnC_Weapon_SniperRifle_Player_Nod")))
		{
			if ( Has_Weapon(sender, "Weapon_SniperRifle_Player") )
			{
				Page(PlayerID, ROYAL_BLUE, "Your weaker, double Sniper Rifle has been removed from your weapons bag.");
				Remove_Weapon(sender, "Weapon_SniperRifle_Player");
			}
			if ( Has_Weapon(sender, "Weapon_SniperRifle_Player_Nod") )
			{
				Page(PlayerID, ROYAL_BLUE, "Your weaker, double Sniper Rifle has been removed from your weapons bag.");
				Remove_Weapon(sender, "Weapon_SniperRifle_Player_Nod");
			}
		}
		else if ((Has_Weapon(sender, "Weapon_VoltAutoRifle_Player")) && (Has_Weapon(sender, "Weapon_VoltAutoRifle_Player_Nod")))
		{
			if ( Team == 0 ) // Nod
			{
				Remove_Weapon(sender, "Weapon_VoltAutoRifle_Player");
			}
			else
			{
				Remove_Weapon(sender, "Weapon_VoltAutoRifle_Player_Nod");
			}
			Page(PlayerID, ROYAL_BLUE, "Your double Volt Auto Rifle has been removed from your weapons bag.");
		}
	}
}

ScriptRegistrant<RemoveWeakerDoubleGun_Script> RemoveWeakerDoubleGun_Script_Registrant("RemoveWeakerDoubleGun_Script","");

RemoveWeakerDoubleGun removeWeakerDoubleGun;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &removeWeakerDoubleGun;
}
